package w83b.w83bOperacionesPaso.w83bListados.w83bActas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListadosActasVivasCentroRepeBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bListadosActasVivasCentroRepeExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadosActasVivasCentrosTrabajoRepes.xls";
		InputStream inputStream = W83bListadosActasVivasCentroRepeExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaLibroRegActas = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosActasVivasCentroRepeBean listadoBean = (W83bListadosActasVivasCentroRepeBean)contexto.get("w83bListadosActasVivasCentrosTrabajoRepesBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
               
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)8); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)8); 
        cell.setCellValue(tituloImagenEs.toString());
        
         
        //MAPEO FORMULARIO
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloAnulacionActaFechaEleccion_eu",idioma).toUpperCase());
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloAnulacionActaFechaEleccion_es",idioma).toUpperCase());
        cell.setCellValue(titulo.toString());
        
        row = sheet.getRow(Short.parseShort("11")); 
        cell = row.getCell(Short.parseShort("2")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.territorio",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.territorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.createCell(Short.parseShort("3"));
        if(StringUtils.isNotEmpty(listadoBean.getTerritorioTxt())){
        	cell.setCellValue(listadoBean.getTerritorioTxt().toUpperCase());
        }
        cell.setCellStyle(excel.styleTexto9);
       
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("3"),11,Short.parseShort("4")));//NOPMD
		}
        cell = row.createCell(Short.parseShort("4"));
        cell.setCellStyle(excel.styleTexto9);
        
        cell = row.getCell(Short.parseShort("6")); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fechEntrada",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.fechEntrada",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.createCell(Short.parseShort("7"));
        if(StringUtils.isNotEmpty(listadoBean.getFentrada())){
        	cell.setCellValue(listadoBean.getFentrada());
        }
        cell.setCellStyle(excel.styleTexto9);
        
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("7"),11,Short.parseShort("8")));//NOPMD
		}
        cell = row.createCell(Short.parseShort("8"));
        cell.setCellStyle(excel.styleTexto9);
        
        row = sheet.getRow(Short.parseShort("14")); // Creacin de la fila 137
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nActa",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nActa",W83bClsConstantes.CONSTANTE_CASTELLANO)
        		);
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fEleccion",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.fEleccion",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        cell = row.getCell(Short.parseShort("2")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.cifNif",W83bClsConstantes.CONSTANTE_CASTELLANO));
        cell = row.getCell(Short.parseShort("3")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nCentro",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.nCentro",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        cell = row.getCell(Short.parseShort("4")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.razonSocial",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        cell = row.getCell(Short.parseShort("8")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.domicilio",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.domicilio",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        cell = row.getCell(Short.parseShort("11")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.actas.municipio",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        cell = row.getCell(Short.parseShort("12")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(
        		Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.convenio",W83bClsConstantes.CONSTANTE_EUSKARA)+
        		" / "
        		+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.convenio",W83bClsConstantes.CONSTANTE_CASTELLANO)
        );
        
        int tamanyoColumna = 0;
        int tamanyoColumnaTemp = 0;
        
        HashMap mapaActas = new HashMap();
        
        if(null!=listaLibroRegActas){
	        for(int i=0;i<listaLibroRegActas.size();i++){
	        	row = sheet.createRow((short)15+i); // Creacin de la fila 1
	        	
	        	//Numero Acta
	        	cell = row.createCell(Short.parseShort("0")); 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getNumacta())){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getNumacta());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Fec Eleccin
	        	cell = row.createCell(Short.parseShort("1")); 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getFeleccion())){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getFeleccion());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//CifNif
	        	cell = row.createCell(Short.parseShort("2")); 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getCcif())){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getCcif());
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//nCentro
	        	cell = row.createCell(Short.parseShort("3")); 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getNcentrotrabajo())){
	        		cell.setCellValue(W83bUtilidades.numero(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getNcentrotrabajo()));
	        	}
	        	cell.setCellStyle(estiloFilaCentro(i,excel));
	        	
	        	//Razon Social
	        	cell = row.createCell(Short.parseShort("4")); 
	        	cell2 = row.createCell(Short.parseShort("5")); 
	        	HSSFCell cell3 = row.createCell(Short.parseShort("6")); 
	        	HSSFCell cell4 = row.createCell(Short.parseShort("7")); 
	        	sheet.addMergedRegion(new Region(15+i,Short.parseShort("4"),15+i,Short.parseShort("7")));//NOPMD 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getRazonsocial())){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getRazonsocial().toUpperCase());
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	cell2.setCellStyle(estiloFila(i,excel));
	        	cell3.setCellStyle(estiloFila(i,excel));
	        	cell4.setCellStyle(estiloFila(i,excel));
	        	tamanyoColumnaTemp = cell.getStringCellValue().length();
	        	tamanyoColumna = tamanyoColumnaTemp/40;
	        	
	        	
	        	//Domicilio
	        	cell = row.createCell(Short.parseShort("8")); 
	        	cell2 = row.createCell(Short.parseShort("9")); 
	        	cell3 = row.createCell(Short.parseShort("10")); 
	        	sheet.addMergedRegion(new Region(15+i,Short.parseShort("8"),15+i,Short.parseShort("10")));//NOPMD 
	        	if (((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getDomic()!=null&&(!"".equals(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getDomic()))){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getDomic().toUpperCase());
	        	}
	        	else{
	        		cell.setCellValue("");
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	cell2.setCellStyle(estiloFila(i,excel));
	        	cell3.setCellStyle(estiloFila(i,excel));
	        	cell4.setCellStyle(estiloFila(i,excel));
	        	tamanyoColumnaTemp = cell.getStringCellValue().length()/30;
	        	if(tamanyoColumnaTemp>tamanyoColumna){
	        		tamanyoColumna = tamanyoColumnaTemp;	        		
	        	}
	        	
	        	//Municipio
	        	cell = row.createCell(Short.parseShort("11")); 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getMunicipio())){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getMunicipio().toUpperCase());
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	tamanyoColumnaTemp = cell.getStringCellValue().length()/18;
	        	if(tamanyoColumnaTemp>tamanyoColumna){
	        		tamanyoColumna = tamanyoColumnaTemp;	        		
	        	}
	        	
	        	//Convocatoria
	        	cell = row.createCell(Short.parseShort("12")); 
	        	if(StringUtils.isNotEmpty(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getDescConvenio())){
	        		cell.setCellValue(((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getDescConvenio().toUpperCase());
	        	}
	        	cell.setCellStyle(estiloFila(i,excel));
	        	tamanyoColumnaTemp = cell.getStringCellValue().length()/33;
	        	if(tamanyoColumnaTemp>tamanyoColumna){
	        		tamanyoColumna = tamanyoColumnaTemp;	        		
	        	}
	        	
	        	if(tamanyoColumna>1){
	        		row.setHeightInPoints((short)((22*tamanyoColumna)+1));
	        	}
	        	
	        	//meto el acta en un hashmapa para poder realizar el update posteriormente de forma fcil
	        	//[CentroTrabajo1,(acta1,acta2,acta3)],[CentroTrabajo2,(acta4,acta5,acta6),...
	        	String nif = ((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getCcif()+((W83bListadosActasVivasCentroRepeBean)listaLibroRegActas.get(i)).getNcentrotrabajo();
	        	List listaActasHash = (ArrayList)mapaActas.get(nif);
	        	if(null==listaActasHash){
	        		listaActasHash = new ArrayList();//NOPMD
	        	}
	        	listaActasHash.add(listaLibroRegActas.get(i));
	        	mapaActas.put(nif,listaActasHash);
	        	//fin meter acta
	        }
        }
        
        contexto.set("w83bHashmapEntradaBean",mapaActas);
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoActas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	

}
